#version 330
#extension GL_EXT_gpu_shader4 : enable
// triangle wavesMod01.fsh  by   akufish
//https://www.shadertoy.com/view/llSyzt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float mat2x2det(vec2 A, vec2 B) {
    return A.x * B.y - B.x * A.y;
}

float inTriangle(vec2 A, vec2 B, vec2 C, vec2 X) {
    float s1 = (mat2x2det(B - A, X - A));
    float s2 = (mat2x2det(C - B, X - B));
    float s3 = (mat2x2det(A - C, X - C));
    
    return sin(log(abs(s1 * s2 * s3)) + iTime);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    float col = abs(inTriangle(iResolution.xy / 2.0 + vec2(-50.0, -25.0),
                           iResolution.xy / 2.0 + vec2(0.0, 50.0), 
                           iResolution.xy / 2.0 + vec2(50.0, -25.0), gl_FragCoord.xy));
	gl_FragColor = vec4(col, col, col, 1.0);
}